//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;

namespace Testing
{
	abstract class Shape
	{
		public abstract void Draw();
	}
	
	class Circle: Shape
	{
		double x;
		double y;
		double r;
		public Circle(double x, double y, double r)
		{
			this.x = x;
			this.y = y;
			this.r = r;
		}
		override public void Draw()
		{
			Console.WriteLine("Rysowanie okrgu o promieniu {0}", r);
		}
	}
	
	class Triangle: Shape
	{
		double [,] vertices;
		public Triangle(double x1, double y1,
		                double x2, double y2,
		                double x3, double y3)
		{
			vertices = new double [,] {{x1, y1},
			                           {x2, y2},
			                           {x3, y3}};
		}
		override public void Draw()
		{
			Console.WriteLine("Rysowanie trjkta");
		}
	}
	
	class Square: Shape
	{
		double x;
		double y;
		double s;
		public Square(double x, double y, double s)
		{
			this.x = x;
			this.y = y;
			this.s = s;
		}
		override public void Draw()
		{
			Console.WriteLine("Rysowanie kwadratu {0}x{0}", s);
		}
	}
	
	class PolymorphicMain
	{
		static void Main(string[] args)
		{
			Shape [] shapes = new Shape [] {new Circle(0,0,2),
											new Triangle(0,0,0,1,1,1),
											new Square(0,0,5)};
			foreach(Shape s in shapes)
			{
				s.Draw();
			}
		}
	}
}
